//Dustin Soodak

//
//behavior 036:
//Look at XY accelerometer and gyroscope
//compare still to moving forward and record accel & gyro data to be spit out later
#include "MiscHardware.h"
#include "Navigation.h"
#include <math.h>
void setup(){
  HardwareBegin();
  SwitchButtonToPixels();
  PlayChirp(1000, 50);SetPixelRGB(5,0,0,50);SetPixelRGB(6,0,0,50);RefreshPixels();
  delay(100);
  PlayChirp(1000, 0);SetPixelRGB(5,0,0,0);SetPixelRGB(6,0,0,0);RefreshPixels();  
  
}
int accelx,accely,accelz,dir;
int i;
int accelraw[3];
int accelrawtemp[3];
int accel[3];
int gyroraw[3];
int gyro[3];
int32_t rawaccelsquared,accelsquared;
//
#define DAT_SIZE (150)
int gyroZ[DAT_SIZE];
int accelX[DAT_SIZE];
int accelY[DAT_SIZE];
int datpos=0;
char motorson=0;
int32_t accelXzero=0,accelYzero,gyrozero=0;
//
char ch;
String NumString="";
int motoroffset=0;
int leftmotor=100,rightmotor=100;
char mode=0;
char gyrobufsize;
void loop(){
  SwitchPixelsToButton();    
  SwitchMotorsToSerial();
  Serial.println("Enter motors, press button to continue");
  Serial.print("motors: ");Serial.print(leftmotor,DEC);Serial.print(" ");Serial.println(rightmotor,DEC);
  Serial.println("enter left motor");
  mode=0;//in this case, used for motor selection
  while(!ButtonPressed()){
    if(Serial.available() > 0){
      ch = Serial.read();    
      if (isDigit(ch) || ch=='-'){        
        NumString += (char)ch;
      }
      if(ch=='\n'){
        if(mode==0){
          leftmotor=NumString.toInt();//-25 works well for robot 1
          Serial.print("motors: ");Serial.print(leftmotor,DEC);Serial.print(" ");Serial.println(rightmotor,DEC);
          Serial.println("enter right motor");
          mode=1;
        }  
        else if(mode==1){
          rightmotor=NumString.toInt();//-25 works well for robot 1
          Serial.print("motors: ");Serial.print(leftmotor,DEC);Serial.print(" ");Serial.println(rightmotor,DEC);
          Serial.println("enter left motor");
          mode=0;
        }
        NumString="";
      }
    }//end if(Serial.available() > 0)
  }
  Serial.println("starting");
  delay(1000);
  NavigationBegin();  
  RestartTimer();
  SwitchButtonToPixels();
  SetPixelRGB(5,50,0,0);SetPixelRGB(6,50,0,0);RefreshPixels();
  datpos=0;
  accelXzero=0;
  accelYzero=0;
  gyrozero=0;
  motorson=0; 
  mode=0;//in this case, used for data collection sequence
  while(1){
    //SimpleNavigation();   
    gyrobufsize=GyroBufferSize();
    if(gyrobufsize>0){//gyro is slower so this should also mean there is some accel data      
      GyroGetAxes(gyroraw);//380 hz 
      AccelGetAxes(accelraw);//400 hz
      if(AccelBufferSize()>gyrobufsize){//to keep buffers in sync
         AccelGetAxes(accelrawtemp);
         for(i=0;i<3;i++){
            accelraw[i]=(accelraw[i]+accelrawtemp[i])/2;
         }
      }   
      
      switch(mode){
      case 0://find zeroes
        if(datpos<(DAT_SIZE)){
          accelXzero+=accelraw[0];
          accelYzero+=accelraw[1];
          gyrozero+=gyroraw[2];
          datpos++;
        }
        else{
          accelXzero=accelXzero/DAT_SIZE;
          accelYzero=accelYzero/DAT_SIZE;
          gyrozero=gyrozero/DAT_SIZE; 
          mode=1;
          datpos=0;
        }        
      break;
      case 1:        
        accelX[datpos]=accelraw[0];
        accelY[datpos]=accelraw[1];//dat[datpos]=accelraw[1];
        gyroZ[datpos]=gyroraw[2];//dat[datpos-(DAT_SIZE>>1)]=gyroraw[2]; 
        datpos++;
        if(datpos==10){
          SwitchMotorsToSerial();Serial.println("motors on");
          SwitchButtonToPixels();
          SetPixelRGB(5,0,50,0);SetPixelRGB(6,0,50,0);RefreshPixels();
          SwitchSerialToMotors();
          Motors(leftmotor,rightmotor);
        }
        if(datpos==2*DAT_SIZE/4){
          SwitchMotorsToSerial();Serial.println("motors twitch");
          SwitchButtonToPixels();
          SetPixelRGB(5,0,0,0);SetPixelRGB(6,0,0,0);RefreshPixels();
          SwitchSerialToMotors();
          Motors(250,-250);
          SwitchMotorsToSerial();          
        }
        if(datpos==3*DAT_SIZE/4){
          SwitchMotorsToSerial();Serial.println("motors off");
          SwitchButtonToPixels();
          SetPixelRGB(5,0,0,0);SetPixelRGB(6,0,0,0);RefreshPixels();
          SwitchSerialToMotors();
          Motors(0,0);
          SwitchMotorsToSerial();          
        }
        if(datpos==DAT_SIZE)
          mode=2;
      break;
      }//end switch(mode)
    }//end if(GyroBufferSize()>0)
      
    if(mode==2){
      SwitchPixelsToButton(); 
      if(ButtonPressed()){
        Serial.println("zeroes: ");
        Serial.print(accelXzero,DEC);
        Serial.print("\t");
        Serial.print(accelYzero,DEC);
        Serial.print("\t");
        Serial.print(gyrozero,DEC);
        Serial.println();
        Serial.println("accelX raw\taccelY raw\tgyro raw");
        for(i=0;i<datpos;i++){
          Serial.print(accelX[i],DEC);
          Serial.print("\t");
          Serial.print(accelY[i],DEC);
          Serial.print("\t");
          Serial.println(gyroZ[i],DEC);
        }
        //
        break;
      }//end if(ButtonPressed())
      SwitchButtonToPixels();   
      if(GetTime()>200){//
        rawaccelsquared=0;
        accelsquared=0;
        for(i=0;i<3;i++){
          accel[i]=accelraw[i]*(-(float)(2*9800)/32768);//range: 2g, g=9.8m/s^2
          rawaccelsquared+=((int32_t)accelraw[i])*((int32_t)accelraw[i]);
          accelsquared+=((int32_t)accel[i])*((int32_t)accel[i]);
          gyro[i]=-((float)gyroraw[i])*2000*0.0000355;
        }  
        //gyro:
        //range	calc dps/dig	"typ" in datasheet	to get to "typ"		
        //250	0.007629395	0.00875           	1.14687993         
        //500	0.015258789	0.0175           	1.146880005
        //2000	0.061035156	0.070            	1.146880005
        // 1/2^15*1.14688=exactly .000035          
        dir=90-atan2(accely,accelx)*180/3.14159;
        SwitchMotorsToSerial();
        Serial.print(accelraw[0],DEC);
        Serial.print(" ");
        Serial.print(accelraw[1],DEC);
        Serial.print(" ");
        Serial.print(accelraw[2],DEC);
        Serial.print(" dir ");
        Serial.println(dir,DEC);
        Serial.print(" ");
        Serial.print(accel[0],DEC);
        Serial.print(" ");
        Serial.print(accel[1],DEC);
        Serial.print(" ");
        Serial.print(accel[2],DEC);
        Serial.println();
        Serial.print(" raw amplitude ");
        Serial.print(sqrt(rawaccelsquared),DEC);
        Serial.print(" amplitude ");    
        Serial.print(sqrt(accelsquared),DEC);
        Serial.print(" gyro raw ");  
        Serial.print(gyroraw[2],DEC);
        Serial.print(" dps ");
        Serial.print(gyro[2],DEC);
        Serial.println();
        RestartTimer(); 
        //          
      }//end if(GetTime()>200)
  }//end if(mode==2)    
    
  }//end while(1)
  
}//end loop()


